#include <bits/stdc++.h>
using namespace std;
struct Point {
    double x, y;
    int idx;
};
struct Edge {
    int u, v;
    double w;
    bool operator<(const Edge &other) const {
        return w < other.w;
    }
};
double manhattan(const Point &a, const Point &b) {
    return abs(a.x - b.x) + abs(a.y - b.y);
}
struct DSU {
    vector<int> p, sz;
    DSU(int n) {
        p.resize(n);
        iota(p.begin(), p.end(), 0);
        sz.assign(n, 1);
    }
    int find(int x) {
        if(p[x] == x) return x;
        return p[x] = find(p[x]);
    }
    bool unite(int a, int b) {
        a = find(a);
        b = find(b);
        if(a == b) return false;
        if(sz[a] < sz[b]) swap(a, b);
        p[b] = a;
        sz[a] += sz[b];
        return true;
    }
};
int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    double eps;
    cin>>n>>eps;
    vector<Point> points(n);
    for(int i = 0; i < n; i++) {
        cin >> points[i].x >> points[i].y;
        points[i].idx = i + 1;
    }
    double grid_size = eps / 2;
    map<pair<int,int>, int> cell_representative;
    vector<int> Q;
    for(int i = 0; i < n; i++) {
        int gx = int(points[i].x / grid_size);
        int gy = int(points[i].y / grid_size);
        pair<int,int> cell = {gx, gy};
        if(cell_representative.find(cell) == cell_representative.end()) {
            cell_representative[cell] = i;
            Q.push_back(i);
        }
    }
    int k = Q.size();
    cout << k << "\n";
    for(int i = 0; i < k; i++) {
        cout << points[Q[i]].idx << (i+1==k ? "\n" : " ");
    }
    vector<Edge> edges;
    for(int i = 0; i < k; i++) {
        for(int j = i+1; j < k; j++) {
            double w = manhattan(points[Q[i]], points[Q[j]]);
            edges.push_back({i, j, w});
        }
    }
    sort(edges.begin(), edges.end());
    DSU dsu(k);
    for(auto &e : edges) {
        if(dsu.unite(e.u, e.v)) {
            cout << points[Q[e.u]].idx << " " << points[Q[e.v]].idx << "\n";
        }
    }
    return 0;
}